/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.server.converter.PropertiesConverter;
import io.edurt.datacap.server.entity.SourceEntity;
import io.edurt.datacap.server.entity.UserEntity;
import io.edurt.datacap.spi.executor.PipelineState;
import java.sql.Timestamp;
import java.util.Properties;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.ObjectUtils;

@Entity
@Table(name="pipeline")
@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
public class PipelineEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="name", unique=true)
    private String name;
    @Column(name="content", unique=true)
    private String content;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private PipelineState state;
    @Column(name="message")
    private String message;
    @Column(name="work")
    private String work;
    @Column(name="start_time", columnDefinition="datetime default CURRENT_TIMESTAMP()")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Timestamp startTime;
    @Column(name="end_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Timestamp endTime;
    @Column(name="elapsed")
    private Long elapsed;
    @ManyToOne
    @JoinColumn(name="user_id")
    @JsonIncludeProperties(value={"id", "username"})
    private UserEntity user;
    @ManyToOne
    @JoinColumn(name="from_id")
    @JsonIncludeProperties(value={"id", "name", "type"})
    private SourceEntity from;
    @Column(name="from_configures")
    @Convert(converter=PropertiesConverter.class)
    private Properties fromConfigures;
    @ManyToOne
    @JoinColumn(name="to_id")
    @JsonIncludeProperties(value={"id", "name", "type"})
    private SourceEntity to;
    @Column(name="to_configures")
    @Convert(converter=PropertiesConverter.class)
    private Properties toConfigures;

    public long getElapsed() {
        if (ObjectUtils.isNotEmpty((Object)this.getEndTime())) {
            this.elapsed = (this.getEndTime().getTime() - this.getStartTime().getTime()) / 1000L;
        }
        return this.elapsed;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public PipelineState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public String getWork() {
        return this.work;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public SourceEntity getFrom() {
        return this.from;
    }

    public Properties getFromConfigures() {
        return this.fromConfigures;
    }

    public SourceEntity getTo() {
        return this.to;
    }

    public Properties getToConfigures() {
        return this.toConfigures;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setState(PipelineState state) {
        this.state = state;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setWork(String work) {
        this.work = work;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public void setFrom(SourceEntity from) {
        this.from = from;
    }

    public void setFromConfigures(Properties fromConfigures) {
        this.fromConfigures = fromConfigures;
    }

    public void setTo(SourceEntity to) {
        this.to = to;
    }

    public void setToConfigures(Properties toConfigures) {
        this.toConfigures = toConfigures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineEntity)) {
            return false;
        }
        PipelineEntity other = (PipelineEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (this.getElapsed() != other.getElapsed()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        PipelineState this$state = this.getState();
        PipelineState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$work = this.getWork();
        String other$work = other.getWork();
        if (this$work == null ? other$work != null : !this$work.equals(other$work)) {
            return false;
        }
        Timestamp this$startTime = this.getStartTime();
        Timestamp other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Timestamp this$endTime = this.getEndTime();
        Timestamp other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        UserEntity this$user = this.getUser();
        UserEntity other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        SourceEntity this$from = this.getFrom();
        SourceEntity other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Properties this$fromConfigures = this.getFromConfigures();
        Properties other$fromConfigures = other.getFromConfigures();
        if (this$fromConfigures == null ? other$fromConfigures != null : !((Object)this$fromConfigures).equals(other$fromConfigures)) {
            return false;
        }
        SourceEntity this$to = this.getTo();
        SourceEntity other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Properties this$toConfigures = this.getToConfigures();
        Properties other$toConfigures = other.getToConfigures();
        return !(this$toConfigures == null ? other$toConfigures != null : !((Object)this$toConfigures).equals(other$toConfigures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PipelineEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        long $elapsed = this.getElapsed();
        result = result * 59 + (int)($elapsed >>> 32 ^ $elapsed);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        PipelineState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $work = this.getWork();
        result = result * 59 + ($work == null ? 43 : $work.hashCode());
        Timestamp $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Timestamp $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        UserEntity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        SourceEntity $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Properties $fromConfigures = this.getFromConfigures();
        result = result * 59 + ($fromConfigures == null ? 43 : ((Object)$fromConfigures).hashCode());
        SourceEntity $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Properties $toConfigures = this.getToConfigures();
        result = result * 59 + ($toConfigures == null ? 43 : ((Object)$toConfigures).hashCode());
        return result;
    }

    public String toString() {
        return "PipelineEntity(id=" + this.getId() + ", name=" + this.getName() + ", content=" + this.getContent() + ", state=" + this.getState() + ", message=" + this.getMessage() + ", work=" + this.getWork() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", elapsed=" + this.getElapsed() + ", user=" + this.getUser() + ", from=" + this.getFrom() + ", fromConfigures=" + this.getFromConfigures() + ", to=" + this.getTo() + ", toConfigures=" + this.getToConfigures() + ")";
    }
}

