/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.server.common.State;
import io.edurt.datacap.server.entity.SourceEntity;
import io.edurt.datacap.server.entity.UserEntity;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="audit_plugin")
@org.hibernate.annotations.Table(appliesTo="audit_plugin", comment="The user records the execution log and history of the plug-in")
@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
public class PluginAuditEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="state", unique=true)
    @Enumerated(value=EnumType.STRING)
    private State state;
    @Column(name="content", unique=true)
    private String content;
    @Column(name="message", unique=true)
    private String message;
    @Column(name="create_time", columnDefinition="datetime(5) default CURRENT_TIMESTAMP()")
    private Timestamp createTime;
    @Column(name="end_time", columnDefinition="datetime(5) default CURRENT_TIMESTAMP()")
    private Timestamp endTime;
    @Column(name="elapsed")
    private Long elapsed;
    @ManyToOne
    @JoinColumn(name="plugin_id")
    @JsonIncludeProperties(value={"id", "name", "type"})
    private SourceEntity plugin;
    @ManyToOne
    @JoinColumn(name="user_id")
    @JsonIncludeProperties(value={"id", "username"})
    private UserEntity user;

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
        this.elapsed = this.endTime.getTime() - this.createTime.getTime();
    }

    public Long getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public String getContent() {
        return this.content;
    }

    public String getMessage() {
        return this.message;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public SourceEntity getPlugin() {
        return this.plugin;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public void setPlugin(SourceEntity plugin) {
        this.plugin = plugin;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginAuditEntity)) {
            return false;
        }
        PluginAuditEntity other = (PluginAuditEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$elapsed = this.getElapsed();
        Long other$elapsed = other.getElapsed();
        if (this$elapsed == null ? other$elapsed != null : !((Object)this$elapsed).equals(other$elapsed)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Timestamp this$createTime = this.getCreateTime();
        Timestamp other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Timestamp this$endTime = this.getEndTime();
        Timestamp other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        SourceEntity this$plugin = this.getPlugin();
        SourceEntity other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !((Object)this$plugin).equals(other$plugin)) {
            return false;
        }
        UserEntity this$user = this.getUser();
        UserEntity other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginAuditEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $elapsed = this.getElapsed();
        result = result * 59 + ($elapsed == null ? 43 : ((Object)$elapsed).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Timestamp $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Timestamp $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        SourceEntity $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : ((Object)$plugin).hashCode());
        UserEntity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "PluginAuditEntity(id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + ", content=" + this.getContent() + ", message=" + this.getMessage() + ", createTime=" + this.getCreateTime() + ", endTime=" + this.getEndTime() + ", elapsed=" + this.getElapsed() + ", plugin=" + this.getPlugin() + ", user=" + this.getUser() + ")";
    }
}

