/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.server.common.JSON;
import io.edurt.datacap.server.entity.PluginAuditEntity;
import io.edurt.datacap.server.entity.UserEntity;
import io.edurt.datacap.server.plugin.configure.IConfigure;
import io.edurt.datacap.server.validation.ValidationGroup;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="source")
@JsonIgnoreProperties(value={"configure"})
@Table(appliesTo="source", comment="The storage is used to query the data connection source")
@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
public class SourceEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty")
    private @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long id;
    @Column(name="name", unique=true, nullable=false)
    @NotEmpty(message="The passed name cannot by empty")
    private @NotEmpty(message="The passed name cannot by empty") String name;
    @Column(name="description")
    private String description;
    @Column(name="_type", nullable=false)
    private String type;
    @Column(name="protocol", unique=true, nullable=false, columnDefinition="varchar default 'HTTP'")
    @NotNull(message="The passed protocol cannot by empty")
    private @NotNull(message="The passed protocol cannot by empty") String protocol;
    @Column(name="host", unique=true, nullable=false)
    @NotEmpty(message="The passed host cannot by empty")
    private @NotEmpty(message="The passed host cannot by empty") String host;
    @Column(name="port", unique=true, nullable=false)
    @NotNull(message="The passed port cannot by empty")
    private @NotNull(message="The passed port cannot by empty") Integer port = 0;
    @Column(name="username")
    private String username;
    @Column(name="password")
    private String password;
    @Column(name="_catalog")
    private String catalog;
    @Column(name="_database")
    private String database;
    @Column(name="create_time", columnDefinition="datetime default CURRENT_TIMESTAMP()")
    private Timestamp createTime;
    @Column(name="_ssl", columnDefinition="boolean default false")
    private Boolean ssl;
    @OneToMany(mappedBy="plugin", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JsonIgnore
    private List<PluginAuditEntity> pluginAudits;
    @Column(name="public", columnDefinition="boolean default false")
    @JsonProperty(value="public")
    private Boolean publish;
    @Column(name="configure")
    @JsonProperty(value="configure")
    private String configure;
    @Transient
    private Map<String, Object> configures;
    @Transient
    private IConfigure schema;
    @ManyToOne
    @JoinColumn(name="user_id")
    @JsonIncludeProperties(value={"id", "username"})
    private UserEntity user;

    public void setConfigure(String configure) {
        this.configure = configure;
        if (StringUtils.isNotEmpty((CharSequence)configure)) {
            this.setConfigures(JSON.toMap(this.configure));
        }
    }

    public Map<String, Object> getConfigures() {
        if (StringUtils.isNotEmpty((CharSequence)this.configure)) {
            this.setConfigures(JSON.toMap(this.configure));
        }
        return this.configures;
    }

    @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty")
    public @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    @NotNull(message="The passed protocol cannot by empty")
    public @NotNull(message="The passed protocol cannot by empty") String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    @NotNull(message="The passed port cannot by empty")
    public @NotNull(message="The passed port cannot by empty") Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public List<PluginAuditEntity> getPluginAudits() {
        return this.pluginAudits;
    }

    public Boolean getPublish() {
        return this.publish;
    }

    public String getConfigure() {
        return this.configure;
    }

    public IConfigure getSchema() {
        return this.schema;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setId(@NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProtocol(@NotNull(message="The passed protocol cannot by empty") @NotNull(message="The passed protocol cannot by empty") String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(@NotNull(message="The passed port cannot by empty") @NotNull(message="The passed port cannot by empty") Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @JsonIgnore
    public void setPluginAudits(List<PluginAuditEntity> pluginAudits) {
        this.pluginAudits = pluginAudits;
    }

    @JsonProperty(value="public")
    public void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public void setConfigures(Map<String, Object> configures) {
        this.configures = configures;
    }

    public void setSchema(IConfigure schema) {
        this.schema = schema;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceEntity)) {
            return false;
        }
        SourceEntity other = (SourceEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$ssl = this.getSsl();
        Boolean other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        Boolean this$publish = this.getPublish();
        Boolean other$publish = other.getPublish();
        if (this$publish == null ? other$publish != null : !((Object)this$publish).equals(other$publish)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        Timestamp this$createTime = this.getCreateTime();
        Timestamp other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        List<PluginAuditEntity> this$pluginAudits = this.getPluginAudits();
        List<PluginAuditEntity> other$pluginAudits = other.getPluginAudits();
        if (this$pluginAudits == null ? other$pluginAudits != null : !((Object)this$pluginAudits).equals(other$pluginAudits)) {
            return false;
        }
        String this$configure = this.getConfigure();
        String other$configure = other.getConfigure();
        if (this$configure == null ? other$configure != null : !this$configure.equals(other$configure)) {
            return false;
        }
        Map<String, Object> this$configures = this.getConfigures();
        Map<String, Object> other$configures = other.getConfigures();
        if (this$configures == null ? other$configures != null : !((Object)this$configures).equals(other$configures)) {
            return false;
        }
        IConfigure this$schema = this.getSchema();
        IConfigure other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        UserEntity this$user = this.getUser();
        UserEntity other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        Boolean $publish = this.getPublish();
        result = result * 59 + ($publish == null ? 43 : ((Object)$publish).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        Timestamp $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        List<PluginAuditEntity> $pluginAudits = this.getPluginAudits();
        result = result * 59 + ($pluginAudits == null ? 43 : ((Object)$pluginAudits).hashCode());
        String $configure = this.getConfigure();
        result = result * 59 + ($configure == null ? 43 : $configure.hashCode());
        Map<String, Object> $configures = this.getConfigures();
        result = result * 59 + ($configures == null ? 43 : ((Object)$configures).hashCode());
        IConfigure $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        UserEntity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "SourceEntity(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", catalog=" + this.getCatalog() + ", database=" + this.getDatabase() + ", createTime=" + this.getCreateTime() + ", ssl=" + this.getSsl() + ", pluginAudits=" + this.getPluginAudits() + ", publish=" + this.getPublish() + ", configure=" + this.getConfigure() + ", configures=" + this.getConfigures() + ", schema=" + this.getSchema() + ", user=" + this.getUser() + ")";
    }
}

