/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.server.entity.RoleEntity;
import io.edurt.datacap.server.entity.SourceEntity;
import io.edurt.datacap.server.validation.ValidationGroup;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@Entity
@Table(name="users", uniqueConstraints={@UniqueConstraint(columnNames={"username"})})
@JsonIgnoreProperties(value={"password"})
@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
public class UserEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class, ValidationGroup.Crud.Auth.class})
    @Size(max=20)
    @Column(name="username")
    private @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class, ValidationGroup.Crud.Auth.class}) @Size(max=20) String username;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class, ValidationGroup.Crud.Auth.class})
    @Size(max=120)
    @Column(name="password")
    private @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class, ValidationGroup.Crud.Auth.class}) @Size(max=120) String password;
    @Column(name="third_configure")
    private String thirdConfigure;
    @Column(name="create_time", columnDefinition="datetime(5) default CURRENT_TIMESTAMP()")
    private Timestamp createTime;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="user_roles", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private Set<RoleEntity> roles = new HashSet<RoleEntity>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JsonIgnore
    private List<SourceEntity> sources;

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getThirdConfigure() {
        return this.thirdConfigure;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Set<RoleEntity> getRoles() {
        return this.roles;
    }

    public List<SourceEntity> getSources() {
        return this.sources;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setThirdConfigure(String thirdConfigure) {
        this.thirdConfigure = thirdConfigure;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setRoles(Set<RoleEntity> roles) {
        this.roles = roles;
    }

    @JsonIgnore
    public void setSources(List<SourceEntity> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserEntity)) {
            return false;
        }
        UserEntity other = (UserEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$thirdConfigure = this.getThirdConfigure();
        String other$thirdConfigure = other.getThirdConfigure();
        if (this$thirdConfigure == null ? other$thirdConfigure != null : !this$thirdConfigure.equals(other$thirdConfigure)) {
            return false;
        }
        Timestamp this$createTime = this.getCreateTime();
        Timestamp other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Set<RoleEntity> this$roles = this.getRoles();
        Set<RoleEntity> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<SourceEntity> this$sources = this.getSources();
        List<SourceEntity> other$sources = other.getSources();
        return !(this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $thirdConfigure = this.getThirdConfigure();
        result = result * 59 + ($thirdConfigure == null ? 43 : $thirdConfigure.hashCode());
        Timestamp $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Set<RoleEntity> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<SourceEntity> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        return result;
    }

    public String toString() {
        return "UserEntity(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", thirdConfigure=" + this.getThirdConfigure() + ", createTime=" + this.getCreateTime() + ", roles=" + this.getRoles() + ", sources=" + this.getSources() + ")";
    }

    public UserEntity() {
    }

    public UserEntity(Long id, String username, String password, String thirdConfigure, Timestamp createTime, Set<RoleEntity> roles, List<SourceEntity> sources) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.thirdConfigure = thirdConfigure;
        this.createTime = createTime;
        this.roles = roles;
        this.sources = sources;
    }
}

