/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.handler;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.edurt.datacap.server.authorize.UserNotEqualsException;
import io.edurt.datacap.server.common.Response;
import io.edurt.datacap.server.common.ServiceState;
import io.edurt.datacap.server.handler.HandlerField;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class HandlerRestful {
    private static final Logger log = LoggerFactory.getLogger(HandlerRestful.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<List<HandlerField>> handlerMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        ArrayList<HandlerField> list = new ArrayList<HandlerField>();
        BindingResult bindingResult = ex.getBindingResult();
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            HandlerField field = new HandlerField();
            field.setField(fieldError.getField());
            field.setMessage(fieldError.getDefaultMessage());
            list.add(field);
        }
        return Response.failure(ServiceState.REQUEST_VALID_ARGUMENT, list);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<String> handlerConstraintViolationException(ConstraintViolationException ex) {
        return Response.failure(ex.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<String> handlerConstraintViolationException(HttpMessageNotReadableException ex) {
        log.error("", (Throwable)ex);
        if (ex.getCause() instanceof InvalidFormatException) {
            return Response.failure(ServiceState.REQUEST_VALID_ARGUMENT_FORMAT);
        }
        return Response.failure(ServiceState.REQUEST_VALID_ARGUMENT_LAYOUT);
    }

    @ExceptionHandler(value={UserNotEqualsException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<String> handlerUserNotEqualsException(UserNotEqualsException ex) {
        return Response.failure(ServiceState.USER_UNAUTHORIZED);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<Object> handlerNoHandlerFoundException(NoHandlerFoundException ex) {
        log.error("", (Throwable)ex);
        return Response.failure(ServiceState.REQUEST_EXCEPTION, ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Response<Object> handlerException(Exception ex) {
        log.error("", (Throwable)ex);
        return Response.failure(ServiceState.REQUEST_EXCEPTION, ex.getMessage());
    }
}

