/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.repository;

import io.edurt.datacap.server.entity.PluginAuditEntity;
import io.edurt.datacap.server.entity.UserEntity;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface PluginAuditRepository
extends PagingAndSortingRepository<PluginAuditEntity, Long> {
    public Page<PluginAuditEntity> findAllByUser(UserEntity var1, Pageable var2);

    public Long countByUser(UserEntity var1);

    @Query(value="SELECT tbl._date AS dataOfDate,   IFNULL(tbr.totalnum, 0) AS dataOfCount,   lastDay AS dataOfLastDay,   lastWeek AS dataOfLastWeek,   `month` AS dataOfMonth,   `week` AS dataOfWeek,   DAYOFWEEK(tbl._date) - 1 AS dataOfDay\nFROM\n  (\n    SELECT\n        @s \\:= @s + 1 AS _index,\n        DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY)) AS _date,\n        if(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY)) = last_day(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY))), 'true', 'false') AS lastDay,\n        if(last_day(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY))) - DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY)) < 7, 'true', 'false') AS lastWeek,\n        month(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY))) AS `month`,\n        week(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY))) AS `week`,\n        day(DATE(DATE_SUB(DATE(CONCAT(YEAR(now()),'-12-31')), INTERVAL @s DAY))) AS `day`\n    FROM\n        information_schema.tables, (SELECT @s \\:= - 1) temp\n    WHERE @s < 365\n    ORDER BY _date\n  ) AS tbl\n  LEFT JOIN (\n    SELECT\n        count(1) AS totalnum,\n        DATE(create_time) create_time\n    FROM audit_plugin\n    WHERE user_id = ?1\n    GROUP BY DATE(create_time)\n  ) AS tbr ON tbl._date = tbr.create_time\nGROUP BY tbl._date", nativeQuery=true)
    public List<Map<String, Object>> selectContributionByUserId(Long var1);

    @Query(value="SELECT count(1) AS dataOfCount, s.name AS dataOfLabel\nFROM audit_plugin AS ap\nLEFT JOIN source AS s ON ap.plugin_id = s.id\nWHERE date_sub(curdate(), interval 7 day) <= date(ap.create_time) AND s.user_id = ?1\nGROUP BY s.name", nativeQuery=true)
    public List<Map<String, Object>> selectRadarByUserId(Long var1);
}

