/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.service;

import io.edurt.datacap.server.adapter.PageRequestAdapter;
import io.edurt.datacap.server.body.FilterBody;
import io.edurt.datacap.server.common.Response;
import io.edurt.datacap.server.entity.PageEntity;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface BaseService<T> {
    default public Response<PageEntity<T>> getAll(PagingAndSortingRepository repository, FilterBody filter) {
        PageRequest pageable = PageRequestAdapter.of(filter);
        return Response.success(PageEntity.build(repository.findAll((Pageable)pageable)));
    }

    default public Response<T> getById(PagingAndSortingRepository repository, Long id) {
        return Response.success(repository.findById((Object)id));
    }

    default public Response<T> saveOrUpdate(PagingAndSortingRepository repository, T configure) {
        return Response.success(repository.save(configure));
    }

    public Response<Long> delete(Long var1);
}

