/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutorService
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncExecutorService.class);
    ThreadPoolExecutor _pool;

    public AsyncExecutorService(int threadCount) {
        super(1, threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        LOG.debug("Preparing to execute task using thread pool consisting of {} active threads in pool of {} threads.", (Object)this.getActiveCount(), (Object)this.getPoolSize());
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
        LOG.debug("Now completed {} tasks. {} still awaiting execution.", (Object)this.getCompletedTaskCount(), (Object)this.getQueue().size());
        super.afterExecute(runnable, throwable);
    }

    void shutdownAndAwaitTermination(ExecutorService pool) {
        LOG.debug("Shutting down execution service.");
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOG.warn("Execution service did not terminate gracefully. Trying hard termination.");
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOG.error("Execution service did not respond to hard termination.");
                }
            }
        }
        catch (InterruptedException ie) {
            LOG.error("Execution service was interrupted while attempting graceful shutdown.");
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void finalize() {
        this.shutdownAndAwaitTermination(this._pool);
        super.finalize();
    }
}

