/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.elasticsearch;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticSearchServer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchServer.class);
    protected final Map<String, String> _configuration;
    private Node _server;
    private String _recoveryWait = "30s";

    public ElasticSearchServer(Map<String, String> configuration) {
        this._configuration = configuration;
    }

    public void start() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting the Elastic Search server node");
        }
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(this._configuration);
        this._server = NodeBuilder.nodeBuilder().loadConfigSettings(false).settings((Settings.Builder)builder).build();
        if ("true".equalsIgnoreCase(System.getProperty("es.max.files"))) {
            String workPath = this._server.settings().get("path.work");
            int maxOpen = this.maxOpenFiles(new File(workPath));
            if (LOG.isInfoEnabled()) {
                LOG.info("The maximum number of open files for user [{}] is {}: ", (Object)System.getProperty("user.name"), (Object)maxOpen);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting the Elastic Search server node with these settings:");
            ImmutableMap map = this._server.settings().getAsMap();
            ArrayList keys = new ArrayList(map.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                LOG.info("    " + key + " : " + ElasticSearchServer.getValue((Map<String, String>)map, key));
            }
        }
        try {
            this._server.start();
        }
        catch (Exception e) {
            LOG.error("Error starting the server", (Throwable)e);
        }
        this.checkServerStatus();
        if (LOG.isInfoEnabled()) {
            LOG.info("Elastic Search server is started.");
        }
    }

    public void stop() {
        this._server.close();
    }

    public Client getClient() {
        return this._server.client();
    }

    protected int maxOpenFiles(File testDir) {
        boolean dirCreated = false;
        if (!testDir.exists()) {
            dirCreated = true;
            testDir.mkdirs();
        }
        ArrayList<RandomAccessFile> files = new ArrayList<RandomAccessFile>();
        try {
            while (true) {
                files.add(new RandomAccessFile(new File(testDir, "tmp" + files.size()), "rw"));
            }
        }
        catch (IOException ioe) {
            int i = 0;
            for (RandomAccessFile raf : files) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                new File(testDir, "tmp" + i++).delete();
            }
            if (dirCreated) {
                this.deleteRecursively(testDir);
            }
            return files.size();
        }
    }

    protected boolean deleteRecursively(File root) {
        return this.deleteRecursively(root, true);
    }

    protected boolean deleteRecursively(File root, boolean deleteRoot) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                for (File aChildren : children) {
                    this.deleteRecursively(aChildren);
                }
            }
            return !deleteRoot || root.delete();
        }
        return false;
    }

    protected ClusterHealthStatus getHealthStatus() {
        try {
            return ((ClusterHealthResponse)((ClusterHealthRequestBuilder)this.getClient().admin().cluster().prepareHealth(new String[0]).setMasterNodeTimeout(TimeValue.parseTimeValue((String)this._recoveryWait, null))).execute().actionGet()).getStatus();
        }
        catch (MasterNotDiscoveredException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("ES has not discovered or elected a master yet. Cannot yet determine health.");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return ClusterHealthStatus.RED;
        }
    }

    protected void checkServerStatus() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Waiting up to {} for ES cluster to achieve YELLOW or GREEN state.", (Object)this._recoveryWait);
        }
        long endTime = System.currentTimeMillis() + TimeValue.parseTimeValue((String)this._recoveryWait, (TimeValue)TimeValue.timeValueSeconds((long)30L)).millis();
        ClusterHealthStatus status = this.getHealthStatus();
        while (status == ClusterHealthStatus.RED && System.currentTimeMillis() < endTime) {
            block8: {
                long delay;
                if (LOG.isInfoEnabled()) {
                    LOG.info("ES cluster status is {}. Waiting for ES recovery.", (Object)status);
                }
                if ((delay = endTime - System.currentTimeMillis()) > 0L) {
                    try {
                        ((ClusterHealthRequestBuilder)this.getClient().admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setMasterNodeTimeout(TimeValue.timeValueMillis((long)delay))).setTimeout(TimeValue.timeValueMillis((long)delay)).execute().actionGet();
                    }
                    catch (MasterNotDiscoveredException e) {
                        if (!LOG.isInfoEnabled()) break block8;
                        LOG.info("ES has not discovered or elected a master yet. Cannot yet determine health.");
                    }
                }
            }
            status = this.getHealthStatus();
        }
        status = this.getHealthStatus();
        if (LOG.isInfoEnabled()) {
            LOG.info("ES cluster status is {}", (Object)status);
        }
        if (ClusterHealthStatus.RED.equals((Object)status)) {
            throw new RuntimeException("ES cluster health status is RED. Server is not able to start.");
        }
    }

    protected static String getValue(Map<String, String> map, String key) {
        if (key.startsWith("cloud.aws.secret")) {
            return "<HIDDEN>";
        }
        return map.get(key);
    }

    public void setRecoveryWait(String recoveryWait) {
        this._recoveryWait = recoveryWait;
    }
}

