/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.transcordia.platform.hazelcast.persistence.DelegatingMapStoreFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastBootstrap.class);
    private Client _esClient;
    private HazelcastInstance _hazelcast;
    private DelegatingMapStoreFactory _mapStoreFactory;

    public HazelcastBootstrap() {
    }

    public HazelcastBootstrap(Client esClient) {
        this._esClient = esClient;
    }

    public void setMapStoreFactory(DelegatingMapStoreFactory mapStoreFactory) {
        this._mapStoreFactory = mapStoreFactory;
    }

    public DelegatingMapStoreFactory getMapStoreFactory() {
        return this._mapStoreFactory;
    }

    public void init() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("----------------------------------------");
            LOG.info("Starting Hazelcast bootstrap process");
        }
        Config config = this.generateConfig();
        this.addMapStoreFactory(config, this._mapStoreFactory);
        this._hazelcast = Hazelcast.newHazelcastInstance((Config)config);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            Set members = this._hazelcast.getCluster().getMembers();
            for (Member member : members) {
                InetSocketAddress address = member.getSocketAddress();
                sb.append(address.toString()).append(", ");
            }
            if (members.size() > 0) {
                sb.setLength(sb.length() - 2);
            } else {
                sb.append("No members identified.");
            }
            LOG.info(String.format("Hazelcast node [%s] joined the cluster. Members: %s", this._hazelcast.getName(), sb.toString()));
            LOG.info("Hazelcast bootstrap process completed");
            LOG.info("----------------------------------------");
        }
    }

    public void destroy() {
        LOG.info("Stopping Hazelcast services");
        Hazelcast.shutdownAll();
        LOG.info("Hazelcast services stopped");
    }

    public HazelcastInstance getHazelcast() {
        return this._hazelcast;
    }

    protected void addMapStoreFactory(Config config, DelegatingMapStoreFactory factory) {
        if (factory == null) {
            return;
        }
        Map mapConfigs = config.getMapConfigs();
        for (Map.Entry entry : mapConfigs.entrySet()) {
            if (((MapConfig)entry.getValue()).getMapStoreConfig() == null) continue;
            ((MapConfig)entry.getValue()).getMapStoreConfig().setFactoryImplementation((Object)factory);
        }
    }

    protected Config generateConfig() {
        Config config = new XmlConfigBuilder().build();
        TcpIpConfig ipConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        if (ipConfig.isEnabled() && this._esClient != null) {
            List<String> ips = this.getClusterIPAddresses();
            config.getNetworkConfig().getJoin().getTcpIpConfig().setMembers(ips);
        }
        return config;
    }

    protected List<String> getClusterIPAddresses() {
        ClusterStateResponse response = (ClusterStateResponse)this._esClient.admin().cluster().prepareState().execute().actionGet();
        ArrayList<String> result = new ArrayList<String>();
        DiscoveryNodes nodes = response.getState().getNodes();
        for (DiscoveryNode node : nodes) {
            TransportAddress transport;
            if (!node.isDataNode() || !((transport = node.getAddress()) instanceof InetSocketTransportAddress)) continue;
            InetSocketTransportAddress address = (InetSocketTransportAddress)transport;
            String ip = address.address().getAddress().getHostAddress();
            result.add(ip);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("The following list of IP addresses were identified in the cluster: " + result.toString());
        }
        return result;
    }
}

