/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.hazelcast.persistence;

import com.hazelcast.core.HazelcastInstance;
import com.transcordia.platform.hazelcast.persistence.MapPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DelegatingMapStore
implements MapPersistence {
    List<MapPersistence> _stores = new ArrayList<MapPersistence>();
    MapPersistence _mapLoader;

    void addMapPersistence(MapPersistence store) {
        this._stores.add(store);
    }

    void setMapLoader(MapPersistence mapLoader) {
        this._mapLoader = mapLoader;
    }

    public Object load(Object key) {
        return this._mapLoader.load(key);
    }

    public Map loadAll(Collection keys) {
        return this._mapLoader.loadAll(keys);
    }

    public Set loadAllKeys() {
        return this._mapLoader.loadAllKeys();
    }

    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        this._mapLoader.init(hazelcastInstance, properties, mapName);
        for (MapPersistence store : this._stores) {
            store.init(hazelcastInstance, properties, mapName);
        }
    }

    public void destroy() {
        for (MapPersistence store : this._stores) {
            store.destroy();
        }
    }

    public void store(Object key, Object value) {
        for (MapPersistence store : this._stores) {
            store.store(key, value);
        }
    }

    public void storeAll(Map map) {
        for (MapPersistence store : this._stores) {
            store.storeAll(map);
        }
    }

    public void delete(Object key) {
        for (MapPersistence store : this._stores) {
            store.delete(key);
        }
    }

    public void deleteAll(Collection keys) {
        for (MapPersistence store : this._stores) {
            store.deleteAll(keys);
        }
    }
}

