/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.hazelcast.persistence;

import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStoreFactory;
import com.transcordia.platform.hazelcast.persistence.DelegatingMapStore;
import com.transcordia.platform.hazelcast.persistence.MapPersistence;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DelegatingMapStoreFactory
implements MapStoreFactory,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingMapStoreFactory.class);
    protected ApplicationContext _applicationContext;

    public DelegatingMapStoreFactory() {
        LOG.info("Instantiating DelegatingMapStoreFactory: {}", (Object)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        LOG.debug("Setting application context: {}", (Object)applicationContext);
        this._applicationContext = applicationContext;
    }

    public MapLoader newMapStore(String mapName, Properties properties) {
        LOG.info("Creating a newMapStore using factory {}, ApplicationContext: {}", (Object)this, (Object)this._applicationContext);
        DelegatingMapStore delegatingMapStore = new DelegatingMapStore();
        String maploader = properties.getProperty("maploader");
        if (maploader == null) {
            throw new IllegalArgumentException("In the Hazelcast configuration, map store must have a 'maploader' property specified.");
        }
        String mapstore = properties.getProperty("mapstore");
        if (mapstore == null) {
            throw new IllegalArgumentException("In the Hazelcast configuration, map store must have a 'mapstore' property specified.");
        }
        String[] storeIds = mapstore.split("[,\\s]+");
        LOG.debug("For mapName {}, found stores: {}", (Object)mapName, (Object)storeIds);
        MapPersistence mapLoader = null;
        for (String storeId : storeIds) {
            MapPersistence mapPersistence = (MapPersistence)this._applicationContext.getBean(storeId);
            delegatingMapStore.addMapPersistence(mapPersistence);
            if (!storeId.equals(maploader)) continue;
            mapLoader = mapPersistence;
        }
        if (mapLoader == null) {
            mapLoader = (MapPersistence)this._applicationContext.getBean(maploader);
        }
        delegatingMapStore.setMapLoader(mapLoader);
        return delegatingMapStore;
    }
}

