/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.hazelcast.persistence;

import com.hazelcast.core.HazelcastInstance;
import com.transcordia.platform.hazelcast.persistence.MapPersistence;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMapPersistence
implements MapPersistence {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMapPersistence.class);
    protected Map<Object, Object> _store = new HashMap<Object, Object>();

    public void delete(Object key) {
        this._store.remove(key);
    }

    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
    }

    public void destroy() {
    }

    public Object load(Object key) {
        LOG.debug("Loading key: {}, from map: {}", key, (Object)this);
        return this._store.get(key);
    }

    public Map loadAll(Collection keys) {
        HashMap result = new HashMap();
        for (Object key : keys) {
            result.put(key, this._store.get(key));
        }
        return result;
    }

    public Set loadAllKeys() {
        return this._store.keySet();
    }

    public void store(Object key, Object value) {
        LOG.debug("Putting key: {} and value: {} into map: {}", new Object[]{key, value, this});
        this._store.put(key, value);
    }

    public void storeAll(Map all) {
        Iterator i$ = all.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = i$.next();
            this._store.put(entry.getKey(), entry.getValue());
        }
    }

    public void deleteAll(Collection keys) {
        for (Object key : keys) {
            this._store.remove(key);
        }
    }

    public void deleteAll() {
        this._store.clear();
    }
}

