/*
 * Decompiled with CFR 0.152.
 */
package com.transcordia.platform.hazelcast.persistence.elasticsearch;

import com.hazelcast.core.HazelcastInstance;
import com.transcordia.platform.hazelcast.persistence.MapPersistence;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchMapPersistence
implements MapPersistence {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchMapPersistence.class);
    private static final String NOT_FOUND = "No key found in Elastic Search when loading index: %s, type: %s, key: %s";
    private static final String ERR_INDEX_CREATION = "Failed to create index %s.";
    protected String _index;
    protected String _type;
    protected Client _esClient;
    protected Charset _encoding;

    public ElasticSearchMapPersistence() {
        LOG.info("Initializing ElasticSearchMapPersistence instance.");
        try {
            this._encoding = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Charset UTF-8 not supported.");
        }
    }

    protected String[] mapParts(String mapName) {
        String[] parts = mapName.split("-");
        if (parts.length != 2) {
            throw new IllegalArgumentException("The Hazelcast map name must be in the format <index>-<type>.");
        }
        return parts;
    }

    protected void checkForIndex(String esIndex) {
        ClusterAdminClient cluster = this._esClient.admin().cluster();
        cluster.prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        ClusterStateResponse response = (ClusterStateResponse)cluster.prepareState().execute().actionGet();
        boolean hasIndex = response.getState().metaData().hasIndex(esIndex);
        if (!hasIndex) {
            LOG.info("Index Not Found, creating index: " + esIndex);
            this._esClient.admin().indices().prepareCreate(esIndex).execute().actionGet();
            LOG.info("Created index, waiting for Yellow state: " + esIndex);
            ClusterHealthResponse health = (ClusterHealthResponse)cluster.prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
            response = (ClusterStateResponse)cluster.prepareState().execute().actionGet();
            hasIndex = response.getState().metaData().hasIndex(esIndex);
            if (!hasIndex) {
                throw new RuntimeException(String.format(ERR_INDEX_CREATION, esIndex));
            }
            LOG.info("Index {} created and cluster is in {} state.", (Object)esIndex, (Object)health.getStatus().name());
        }
        LOG.info("Index {} already exists.", (Object)esIndex);
    }

    public void setEsClient(Client esClient) {
        this._esClient = esClient;
    }

    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing the ES persistence for map {}. Additional props: {}", (Object)mapName, (Object)properties.toString());
        }
        String[] parts = this.mapParts(mapName);
        this._index = parts[0];
        this._type = parts[1];
        this.checkForIndex(this._index);
    }

    public void destroy() {
        this._esClient.close();
    }

    public void delete(Object key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting document, index [{}], type [{}], key [{}]", new Object[]{this._index, this._type, key});
        }
        DeleteRequest request = (DeleteRequest)this._esClient.prepareDelete(this._index, this._type, (String)key).request();
        try {
            this._esClient.delete(request).actionGet();
        }
        catch (ElasticsearchException e) {
            LOG.warn("Failed to delete, index [{}], type [[]], key [{}]", (Object)new Object[]{this._index, this._type, key}, (Object)e);
        }
    }

    public void deleteAll(Collection keys) {
        for (Object key : keys) {
            this.delete(key);
        }
    }

    public void storeAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = i$.next();
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void store(Object key, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("store, index: %s, mapName: %s, key: %s, instance: %s", this._index, this._type, key, this.toString()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Indexing document, index [{}], type [{}], key [{}]", new Object[]{this._index, this._type, key});
        }
        IndexRequestBuilder builder = this._esClient.prepareIndex(this._index, this._type, (String)key);
        if (value instanceof String) {
            builder.setSource((String)value);
        } else if (value instanceof byte[]) {
            builder.setSource((byte[])value);
        } else {
            throw new IllegalArgumentException("This persistor can only save byte[] and String types.");
        }
        try {
            this._esClient.index((IndexRequest)builder.request()).actionGet();
        }
        catch (ElasticsearchException e) {
            LOG.warn(String.format("Failed to index, index [%s], type [%s], key [%s], value [%s]", this._index, this._type, key, value), (Throwable)e);
            throw e;
        }
    }

    public Object load(Object key) {
        GetResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading document, index [{}], type [{}], key [{}]", new Object[]{this._index, this._type, key});
        }
        if ((response = (GetResponse)this._esClient.prepareGet(this._index, this._type, (String)key).setRealtime(Boolean.valueOf(true)).execute().actionGet()).isSourceEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format(NOT_FOUND, response.getIndex(), response.getType(), response.getId()));
            }
            return null;
        }
        Map result = response.getSource();
        result.put("_type", response.getType());
        result.put("_index", response.getIndex());
        result.put("_version", response.getVersion());
        try {
            return XContentFactory.jsonBuilder().map(result).string();
        }
        catch (IOException e) {
            LOG.error("Failed to convert map to JSON string loading key [" + key + "]", (Throwable)e);
            return null;
        }
    }

    public Map loadAll(Collection keys) {
        HashMap result = new HashMap(keys.size());
        for (Object key : keys) {
            result.put(key, this.load(key));
        }
        return result;
    }

    public Set loadAllKeys() {
        return null;
    }
}

