package io.embrace.android.embracesdk

import android.app.Activity
import android.os.Bundle

/**
 * Listener implemented by observers of the [ActivityService].
 */
@InternalApi
public interface ActivityListener {

    /**
     * Triggered when the app enters the background.
     */
    public fun onBackground(timestamp: Long) {}

    /**
     * Triggered when the application is resumed.
     *
     * @param coldStart   whether this is a cold start
     * @param startupTime the timestamp at which the application started
     */
    public fun onForeground(coldStart: Boolean, startupTime: Long, timestamp: Long) {}

    /**
     * Triggered when the application has completed startup;
     */
    public fun applicationStartupComplete() {}

    /**
     * Triggered when an activity is opened.
     *
     * @param activity details of the activity
     */
    public fun onView(activity: Activity) {}

    /**
     * Triggered when an activity is closed.
     *
     * @param activity details of the activity
     */
    public fun onViewClose(activity: Activity) {}

    /**
     * Triggered when an activity is created.
     *
     * @param activity the activity
     * @param bundle   the bundle
     */
    public fun onActivityCreated(activity: Activity, bundle: Bundle?) {}
}
