package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName
import io.embrace.android.embracesdk.comms.ApiClient
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanData
import io.embrace.android.embracesdk.payload.AppInfo
import io.embrace.android.embracesdk.payload.DeviceInfo
import io.embrace.android.embracesdk.payload.PerformanceInfo
import io.embrace.android.embracesdk.payload.UserInfo

/**
 * The session message, containing the session itself, as well as performance information about the
 * device which occurred during the session.
 */
internal data class BackgroundActivityMessage @JvmOverloads internal constructor(

    /**
     * The session information.
     */
    @SerializedName("s")
    val backgroundActivity: BackgroundActivity,

    /**
     * The user information.
     */
    @SerializedName("u")
    val userInfo: UserInfo?,

    /**
     * The app information.
     */
    @SerializedName("a")
    val appInfo: AppInfo,

    /**
     * The device information.
     */
    @SerializedName("d")
    val deviceInfo: DeviceInfo,

    /**
     * The device's performance info, such as power, cpu, network.
     */
    @SerializedName("p")
    val performanceInfo: PerformanceInfo,

    /**
     * Breadcrumbs which occurred as part of this session.
     */
    @SerializedName("br")
    val breadcrumbs: Breadcrumbs,

    @SerializedName("spans")
    val spans: List<EmbraceSpanData>?,

    @SerializedName("v")
    val version: Int = ApiClient.MESSAGE_VERSION
)
