package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.gating.Sanitizable
import io.embrace.android.embracesdk.gating.SessionGatingKeys.BREADCRUMBS_CUSTOM
import io.embrace.android.embracesdk.gating.SessionGatingKeys.BREADCRUMBS_CUSTOM_VIEWS
import io.embrace.android.embracesdk.gating.SessionGatingKeys.BREADCRUMBS_TAPS
import io.embrace.android.embracesdk.gating.SessionGatingKeys.BREADCRUMBS_VIEWS
import io.embrace.android.embracesdk.gating.SessionGatingKeys.BREADCRUMBS_WEB_VIEWS
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class BreadcrumbsSanitizer(
    private val breadcrumbs: Breadcrumbs?,
    private val enabledComponents: Set<String>
) :
    Sanitizable<Breadcrumbs> {

    override fun sanitize(): Breadcrumbs? {
        InternalStaticEmbraceLogger.logger.logDeveloper(
            "BreadcrumbsSanitizer",
            "sanitize: " + (breadcrumbs != null).toString()
        )
        return breadcrumbs?.let {
            val sanitizedBreadcrumbsBuilder = Breadcrumbs.newBuilder()

            if (shouldAddCustomBreadcrumbs()) {
                InternalStaticEmbraceLogger.logger.logDeveloper(
                    "BreadcrumbsSanitizer",
                    "shouldAddCustomBreadcrumbs"
                )
                sanitizedBreadcrumbsBuilder.withCustomBreadcrumbs(breadcrumbs.customBreadcrumbs)
            }

            if (shouldAddViewBreadcrumbs()) {
                InternalStaticEmbraceLogger.logger.logDeveloper(
                    "BreadcrumbsSanitizer",
                    "shouldAddViewBreadcrumbs"
                )
                sanitizedBreadcrumbsBuilder.withViewBreadcrumbs(breadcrumbs.viewBreadcrumbs)
            }

            if (shouldAddCustomViewBreadcrumbs()) {
                InternalStaticEmbraceLogger.logger.logDeveloper(
                    "BreadcrumbsSanitizer",
                    "shouldAddCustomViewBreadcrumbs"
                )
                sanitizedBreadcrumbsBuilder.withFragmentBreadcrumbs(breadcrumbs.fragmentBreadcrumbs)
            }

            if (shouldAddTapBreadcrumbs()) {
                InternalStaticEmbraceLogger.logger.logDeveloper(
                    "BreadcrumbsSanitizer",
                    "shouldAddTapBreadcrumbs"
                )
                sanitizedBreadcrumbsBuilder.withTapBreadcrumbs(breadcrumbs.tapBreadcrumbs)
            }

            if (shouldAddWebViewBreadcrumbs()) {
                InternalStaticEmbraceLogger.logger.logDeveloper(
                    "BreadcrumbsSanitizer",
                    "shouldAddWebViewBreadcrumbs"
                )
                sanitizedBreadcrumbsBuilder.withWebViewBreadcrumbs(breadcrumbs.webViewBreadcrumbs)
            }

            return sanitizedBreadcrumbsBuilder.build()
        }
    }

    private fun shouldAddTapBreadcrumbs() =
        enabledComponents.contains(BREADCRUMBS_TAPS)

    private fun shouldAddViewBreadcrumbs() =
        enabledComponents.contains(BREADCRUMBS_VIEWS)

    private fun shouldAddCustomViewBreadcrumbs() =
        enabledComponents.contains(BREADCRUMBS_CUSTOM_VIEWS)

    private fun shouldAddWebViewBreadcrumbs() =
        enabledComponents.contains(BREADCRUMBS_WEB_VIEWS)

    private fun shouldAddCustomBreadcrumbs() =
        enabledComponents.contains(BREADCRUMBS_CUSTOM)
}
