package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.network.http.HttpMethod
import io.embrace.android.embracesdk.network.http.NetworkCaptureData

internal class EmbraceInternalInterfaceImpl(
    private val embrace: EmbraceImpl
) : EmbraceInternalInterface {

    override fun logInfo(message: String, properties: Map<String, Any>?) {
        embrace.logMessage(
            EmbraceEvent.Type.INFO_LOG,
            message,
            properties,
            false,
            null,
            null,
            LogExceptionType.NONE,
            null,
            null
        )
    }

    override fun logWarning(
        message: String,
        properties: Map<String, Any>?,
        allowScreenshot: Boolean,
        stacktrace: String?
    ) {
        embrace.logMessage(
            EmbraceEvent.Type.WARNING_LOG,
            message,
            properties,
            allowScreenshot,
            null,
            stacktrace,
            LogExceptionType.NONE,
            null,
            null
        )
    }

    override fun logError(
        message: String,
        properties: Map<String, Any>?,
        allowScreenshot: Boolean,
        stacktrace: String?,
        isException: Boolean,
    ) {
        embrace.logMessage(
            EmbraceEvent.Type.ERROR_LOG,
            message,
            properties,
            allowScreenshot,
            null,
            stacktrace,
            LogExceptionType.NONE,
            null,
            null
        )
    }

    override fun logHandledException(
        throwable: Throwable,
        type: LogType,
        properties: Map<String, Any>?,
        customStackTrace: Array<out StackTraceElement>?,
        takeScreenshot: Boolean
    ) {
        embrace.logMessage(
            type.toEventType(),
            throwable.message ?: "",
            properties,
            takeScreenshot,
            customStackTrace ?: throwable.stackTrace,
            null,
            LogExceptionType.NONE,
            null,
            null
        )
    }

    override fun logBreadcrumb(message: String) {
        embrace.logBreadcrumb(message)
    }

    override fun getDeviceId(): String {
        return embrace.deviceId
    }

    override fun setUserIdentifier(userId: String?) {
        embrace.setUserIdentifier(userId)
    }

    override fun clearUserIdentifier() {
        embrace.clearUserIdentifier()
    }

    override fun setUsername(username: String?) {
        embrace.setUsername(username)
    }

    override fun clearUsername() {
        embrace.clearUsername()
    }

    override fun setUserEmail(email: String?) {
        embrace.setUserEmail(email)
    }

    override fun clearUserEmail() {
        embrace.clearUserEmail()
    }

    override fun setUserAsPayer() {
        embrace.setUserAsPayer()
    }

    override fun clearUserAsPayer() {
        embrace.clearUserAsPayer()
    }

    override fun setUserPersona(persona: String) {
        embrace.setUserPersona(persona)
    }

    override fun clearUserPersona(persona: String) {
        embrace.clearUserPersona(persona)
    }

    override fun clearAllUserPersonas() {
        embrace.clearAllUserPersonas()
    }

    override fun addSessionProperty(key: String, value: String, permanent: Boolean): Boolean {
        return embrace.addSessionProperty(key, value, permanent)
    }

    override fun removeSessionProperty(key: String): Boolean {
        return embrace.removeSessionProperty(key)
    }

    override fun getSessionProperties(): Map<String, String>? {
        return embrace.sessionProperties
    }

    override fun startEvent(
        name: String,
        identifier: String?,
        allowScreenshot: Boolean,
        properties: Map<String, Any>?
    ) {
        embrace.startEvent(name, identifier, allowScreenshot, properties)
    }

    override fun endEvent(name: String, identifier: String?, properties: Map<String, Any>?) {
        embrace.endEvent(name, identifier, properties)
    }

    override fun startView(name: String): Boolean {
        return embrace.startFragment(name)
    }

    override fun endView(name: String): Boolean {
        return embrace.endFragment(name)
    }

    override fun endAppStartup(properties: Map<String, Any>) {
        embrace.endAppStartup(properties)
    }

    override fun logInternalError(message: String?, details: String?) {
        embrace.logInternalError(message, details)
    }

    override fun endSession(clearUserInfo: Boolean) {
        embrace.endSession(clearUserInfo)
    }

    override fun logNetworkClientError(
        url: String,
        httpMethod: String,
        startTime: Long,
        endTime: Long,
        errorType: String,
        errorMessage: String,
        traceId: String?,
        networkCaptureData: NetworkCaptureData?
    ) {
        embrace.logNetworkClientError(
            url,
            HttpMethod.fromString(httpMethod),
            startTime,
            endTime,
            errorType,
            errorMessage,
            traceId,
            null
        )
    }

    override fun logNetworkRequest(
        url: String,
        httpMethod: String,
        startTime: Long,
        endTime: Long,
        bytesSent: Int,
        bytesReceived: Int,
        statusCode: Int,
        error: String?,
        traceId: String?
    ) {
        embrace.logNetworkRequest(
            url,
            HttpMethod.fromString(httpMethod).ordinal,
            startTime,
            endTime,
            bytesSent,
            bytesReceived,
            statusCode,
            error
        )
    }
}
