package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName
import io.embrace.android.embracesdk.comms.ApiClient
import io.embrace.android.embracesdk.payload.AppInfo
import io.embrace.android.embracesdk.payload.Crash
import io.embrace.android.embracesdk.payload.DeviceInfo
import io.embrace.android.embracesdk.payload.PerformanceInfo
import io.embrace.android.embracesdk.payload.Stacktraces
import io.embrace.android.embracesdk.payload.UserInfo

internal data class EventMessage(
    @SerializedName("et")
    val event: Event,

    @SerializedName("cr")
    val crash: Crash? = null,

    @SerializedName("d")
    val deviceInfo: DeviceInfo? = null,

    @SerializedName("a")
    val appInfo: AppInfo? = null,

    @SerializedName("u")
    val userInfo: UserInfo? = null,

    @SerializedName("p")
    val performanceInfo: PerformanceInfo? = null,

    @SerializedName("sk")
    val stacktraces: Stacktraces? = null,

    @SerializedName("v")
    val version: Int = ApiClient.MESSAGE_VERSION,

    @SerializedName("crn")
    val nativeCrash: NativeCrash? = null
)
