package io.embrace.android.embracesdk;

import androidx.annotation.Nullable;

/**
 * Provides an internal interface to Embrace that is intended for use by Flutter as its
 * sole source of communication with the Android SDK.
 */
interface FlutterInternalInterface extends EmbraceInternalInterface {

    /**
     * {@see Embrace#setEmbraceFlutterSdkVersion}
     */
    void setEmbraceFlutterSdkVersion(@Nullable String version);

    /**
     * {@see Embrace#setDartVersion}
     */
    void setDartVersion(@Nullable String version);

    /**
     * {@see Embrace#logDartError}
     */
    @Deprecated
    void logDartError(
        @Nullable String stack,
        @Nullable String message,
        @Nullable String context,
        @Nullable String library
    );

    /**
     * {@see Embrace#logDartError}
     */
    @Deprecated
    void logDartError(
        @Nullable String stack,
        @Nullable String message,
        @Nullable String context,
        @Nullable String library,
        @Nullable String runtimeType
    );

    /**
     * {@see Embrace#logHandledDartError}
     */
    void logHandledDartError(
        @Nullable String stack,
        @Nullable String name,
        @Nullable String message,
        @Nullable String context,
        @Nullable String library
    );

    /**
     * {@see Embrace#logUnhandledDartError}
     */
    void logUnhandledDartError(
        @Nullable String stack,
        @Nullable String name,
        @Nullable String message,
        @Nullable String context,
        @Nullable String library
);

}
