package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.logging.InternalEmbraceLogger

internal class FlutterInternalInterfaceImpl(
    private val embrace: EmbraceImpl,
    private val impl: EmbraceInternalInterface,
    private val metadataService: MetadataService,
    private val logger: InternalEmbraceLogger
) : EmbraceInternalInterface by impl, FlutterInternalInterface {

    override fun setEmbraceFlutterSdkVersion(version: String?) {
        if (embrace.isStarted) {
            if (version != null) {
                metadataService.setEmbraceFlutterSdkVersion(version)
            }
        } else {
            logger.logSDKNotInitialized("setEmbraceFlutterSdkVersion")
        }
    }

    override fun setDartVersion(version: String?) {
        if (embrace.isStarted) {
            if (version != null) {
                metadataService.setDartVersion(version)
            }
        } else {
            logger.logSDKNotInitialized("setDartVersion")
        }
    }

    @Deprecated("Use logHandledDartError or logUnhandledDartError instead")
    override fun logDartError(
        stack: String?,
        message: String?,
        context: String?,
        library: String?
    ) {
        logDartError(stack, null, message, context, library, LogExceptionType.UNHANDLED)
    }

    @Deprecated("Use logHandledDartError or logUnhandledDartError instead")
    override fun logDartError(
        stack: String?,
        message: String?,
        context: String?,
        library: String?,
        errorType: String?
    ) {
        logDartError(stack, errorType, message, context, library, LogExceptionType.UNHANDLED)
    }

    override fun logHandledDartError(
        stack: String?,
        name: String?,
        message: String?,
        context: String?,
        library: String?
    ) {
        logDartError(stack, name, message, context, library, LogExceptionType.HANDLED)
    }

    override fun logUnhandledDartError(
        stack: String?,
        name: String?,
        message: String?,
        context: String?,
        library: String?
    ) {
        logDartError(stack, name, message, context, library, LogExceptionType.UNHANDLED)
    }

    private fun logDartError(
        stack: String?,
        name: String?,
        message: String?,
        context: String?,
        library: String?,
        exceptionType: LogExceptionType
    ) {
        if (embrace.isStarted) {
            if (stack == null) {
                return
            }

            embrace.logMessage(
                EmbraceEvent.Type.ERROR_LOG,
                "Dart error",
                null,
                false,
                null,
                stack,
                exceptionType,
                context,
                library,
                name,
                message
            )
        } else {
            logger.logSDKNotInitialized("logDartError")
        }
    }
}
