package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents a fragment that was viewed.
 */
class FragmentBreadcrumb implements Breadcrumb {

    @SerializedName("n")
    private final String name;

    @SerializedName("st")
    long startTime;

    @SerializedName("en")
    private long endTime;

    FragmentBreadcrumb(String name, long startTime, long endTime) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getName() {
        return name;
    }

    public long getStartTime() {
        return startTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FragmentBreadcrumb that = (FragmentBreadcrumb) o;

        if (startTime != that.startTime) {
            return false;
        }
        if (endTime != that.endTime) {
            return false;
        }
        return name != null ? name.equals(that.name) : that.name == null;
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (int) (startTime ^ (startTime >>> 32));
        result = 31 * result + (int) (endTime ^ (endTime >>> 32));
        return result;
    }
}
