package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Map;

class NativeCrash {

    @SerializedName("id")
    private final String id;

    @SerializedName("m")
    private final String crashMessage;

    @SerializedName("sb")
    private Map<String, String> symbols;

    @SerializedName("er")
    private List<NativeCrashData.Error> errors;

    @SerializedName("ue")
    private final int unwindError;

    @SerializedName("ma")
    private String map;

    NativeCrash(String id,
                String crashMessage,
                Map<String, String> symbols,
                List<NativeCrashData.Error> errors,
                int unwindError,
                String map) {
        this.id = id;
        this.crashMessage = crashMessage;
        this.symbols = symbols;
        this.errors = errors;
        this.unwindError = unwindError;
        this.map = map;
    }

    public Map<String, String> getSymbols() {
        return symbols;
    }

    public List<NativeCrashData.Error> getErrors() {
        return errors;
    }
    public int getUnwindError() {
        return unwindError;
    }

    public String getId() {
        return id;
    }
}
