package io.embrace.android.embracesdk;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Provides an internal interface to Embrace that is intended for use by React Native as its
 * sole source of communication with the Android SDK.
 */
interface ReactNativeInternalInterface extends EmbraceInternalInterface {

    /**
     * {@see Embrace#logUnhandledJsException}
     */
    void logUnhandledJsException(@NonNull String name,
                                 @NonNull String message,
                                 @Nullable String type,
                                 @Nullable String stacktrace);

    /**
     * {@see Embrace#setJavaScriptPatchNumber}
     */
    void setJavaScriptPatchNumber(@Nullable String number);

    /**
     * {@see Embrace#setReactNativeVersionNumber}
     */
    void setReactNativeVersionNumber(@Nullable String version);

    /**
     * {@see Embrace#setJavaScriptBundleURL}
     */
    void setJavaScriptBundleUrl(@NonNull Context context, @NonNull String url);

}
