package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName
import io.embrace.android.embracesdk.comms.ApiClient
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanData
import io.embrace.android.embracesdk.payload.AppInfo
import io.embrace.android.embracesdk.payload.DeviceInfo
import io.embrace.android.embracesdk.payload.PerformanceInfo
import io.embrace.android.embracesdk.payload.UserInfo

/**
 * The session message, containing the session itself, as well as performance information about the
 * device which occurred during the session.
 */
internal data class SessionMessage @JvmOverloads internal constructor(

    /**
     * The session information.
     */
    @SerializedName("s")
    val session: Session,

    /**
     * The user information.
     */
    @SerializedName("u")
    val userInfo: UserInfo? = null,

    /**
     * The app information.
     */
    @SerializedName("a")
    val appInfo: AppInfo? = null,

    /**
     * The device information.
     */
    @SerializedName("d")
    val deviceInfo: DeviceInfo? = null,

    /**
     * The device's performance info, such as power, cpu, network.
     */
    @SerializedName("p")
    val performanceInfo: PerformanceInfo? = null,

    /**
     * Breadcrumbs which occurred as part of this session.
     */
    @SerializedName("br")
    val breadcrumbs: Breadcrumbs? = null,

    @SerializedName("spans")
    val spans: List<EmbraceSpanData>? = null,

    @SerializedName("v")
    val version: Int = ApiClient.MESSAGE_VERSION
)
