package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.injection.CoreModule
import io.embrace.android.embracesdk.injection.CustomerLogModule
import io.embrace.android.embracesdk.injection.DataCaptureServiceModule
import io.embrace.android.embracesdk.injection.DataContainerModule
import io.embrace.android.embracesdk.injection.DeliveryModule
import io.embrace.android.embracesdk.injection.EssentialServiceModule
import io.embrace.android.embracesdk.injection.SdkObservabilityModule
import io.embrace.android.embracesdk.injection.singleton
import io.embrace.android.embracesdk.worker.WorkerName
import io.embrace.android.embracesdk.worker.WorkerThreadModule

internal interface SessionModule {
    val sessionHandler: SessionHandler
    val sessionService: SessionService
    val backgroundActivityService: BackgroundActivityService?
}

internal class SessionModuleImpl(
    coreModule: CoreModule,
    essentialServiceModule: EssentialServiceModule,
    nativeModule: NativeModule,
    dataContainerModule: DataContainerModule,
    deliveryModule: DeliveryModule,
    sessionProperties: EmbraceSessionProperties,
    dataCaptureServiceModule: DataCaptureServiceModule,
    customerLogModule: CustomerLogModule,
    sdkObservabilityModule: SdkObservabilityModule,
    workerThreadModule: WorkerThreadModule
) : SessionModule {

    override val sessionHandler: SessionHandler by singleton {
        SessionHandler(
            coreModule.logger,
            essentialServiceModule.configService,
            essentialServiceModule.preferencesService,
            essentialServiceModule.userService,
            dataCaptureServiceModule.networkConnectivityService,
            essentialServiceModule.metadataService,
            essentialServiceModule.gatingService,
            dataCaptureServiceModule.breadcrumbService,
            essentialServiceModule.activityService,
            nativeModule.ndkService,
            dataContainerModule.eventService,
            customerLogModule.remoteLogger,
            sdkObservabilityModule.exceptionService,
            dataContainerModule.performanceInfoService,
            essentialServiceModule.memoryCleanerService,
            deliveryModule.deliveryService,
            dataCaptureServiceModule.webviewService,
            dataCaptureServiceModule.activityLifecycleBreadcrumbService,
            dataCaptureServiceModule.thermalStatusService,
            nativeModule.nativeThreadSamplerService,
            coreModule.clock,
            workerThreadModule.scheduledExecutor(WorkerName.SESSION_CLOSER),
            workerThreadModule.scheduledExecutor(WorkerName.SESSION_CACHING),
            workerThreadModule.backgroundWorker(WorkerName.SESSION)
        )
    }

    override val sessionService: SessionService by singleton {
        EmbraceSessionService(
            essentialServiceModule.activityService,
            nativeModule.ndkService,
            sessionProperties,
            coreModule.logger,
            sessionHandler,
            deliveryModule.deliveryService,
            essentialServiceModule.configService.autoDataCaptureBehavior.isNdkEnabled(),
            coreModule.clock,
            dataContainerModule.spansService
        )
    }

    override val backgroundActivityService: BackgroundActivityService? by singleton {
        if (essentialServiceModule.configService.isBackgroundActivityCaptureEnabled()) {
            EmbraceBackgroundActivityService(
                dataContainerModule.performanceInfoService,
                essentialServiceModule.metadataService,
                dataCaptureServiceModule.breadcrumbService,
                essentialServiceModule.activityService,
                dataContainerModule.eventService,
                customerLogModule.remoteLogger,
                essentialServiceModule.userService,
                sdkObservabilityModule.exceptionService,
                deliveryModule.deliveryService,
                essentialServiceModule.configService,
                nativeModule.ndkService,
                coreModule.clock,
                dataContainerModule.spansService,
                lazy { workerThreadModule.backgroundWorker(WorkerName.SESSION_CACHE_WORKER) }
            )
        } else {
            null
        }
    }
}
