package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Provides an internal interface to Embrace that is intended for use by Unity as its
 * sole source of communication with the Android SDK.
 */
interface UnityInternalInterface extends EmbraceInternalInterface {

    /**
     * {@see Embrace#setUnityMetaData}
     */
    void setUnityMetaData(@Nullable String unityVersion, @Nullable String buildGuid, @Nullable String unitySdkVersion);

    /**
     * {@see Embrace#logUnhandledUnityException}
     */
    @Deprecated
    void logUnhandledUnityException(@NonNull String message, @Nullable String stacktrace);

    /**
     * {@see Embrace#logUnhandledUnityException}
     */
    void logUnhandledUnityException(
        @NonNull String name,
        @NonNull String message,
        @Nullable String stacktrace
    );

    /**
     * {@see Embrace#logHandledUnityException}
     */
    void logHandledUnityException(
        @NonNull String name,
        @NonNull String message,
        @Nullable String stacktrace
    );
}