package io.embrace.android.embracesdk;

import androidx.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents the display event for a View.
 */
final class ViewBreadcrumb implements Breadcrumb {

    private static final String FALLBACK_SCREEN_NAME = "Unknown screen";

    /**
     * The screen name for the view breadcrumb.
     */
    @SerializedName("vn")
    private final String screen;

    /**
     * The timestamp at which the view started.
     */
    @SerializedName("st")
    private final Long start;

    /**
     * The timestamp at which the view ended.
     */
    @SerializedName("en")
    private Long end;

    ViewBreadcrumb(String screen, long start) {
        this.start = start;
        this.end = null;
        this.screen = screen != null ? screen : FALLBACK_SCREEN_NAME;
    }

    @Nullable
    String getScreen() {
        return screen;
    }

    public long getStart() {
        return start;
    }

    public long getEnd() {
        return end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    @Override
    public long getStartTime() {
        return start;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ViewBreadcrumb that = (ViewBreadcrumb) o;

        if (screen != null ? !screen.equals(that.screen) : that.screen != null) {
            return false;
        }
        if (start != null ? !start.equals(that.start) : that.start != null) {
            return false;
        }
        return end != null ? end.equals(that.end) : that.end == null;
    }

    @Override
    public int hashCode() {
        int result = screen != null ? screen.hashCode() : 0;
        result = 31 * result + (start != null ? start.hashCode() : 0);
        result = 31 * result + (end != null ? end.hashCode() : 0);
        return result;
    }
}
