package io.embrace.android.embracesdk;

import androidx.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents the onPageStarted event for a WebView.
 */
class WebViewBreadcrumb implements Breadcrumb {

    @SerializedName("u")
    private final String url;

    @SerializedName("st")
    private final long startTime;


    WebViewBreadcrumb(String url, long timestamp) {
        this.url = url;
        this.startTime = timestamp;
    }

    @Nullable
    String getUrl() {
        return url;
    }

    @Override
    public long getStartTime() {
        return startTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        WebViewBreadcrumb that = (WebViewBreadcrumb) o;

        if (startTime != that.startTime) {
            return false;
        }
        return url != null ? url.equals(that.url) : that.url == null;
    }

    @Override
    public int hashCode() {
        int result = url != null ? url.hashCode() : 0;
        result = 31 * result + (int) (startTime ^ (startTime >>> 32));
        return result;
    }
}
