package io.embrace.android.embracesdk.capture.screenshot

/**
 * Service for taking a screenshot of the app for a slow moment or a particular log event.
 */
internal interface ScreenshotService {

    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param logId the ID of the event
     * @return whether the screenshot was successfully taken or not
     */
    fun takeScreenshotLogEvent(logId: String): Boolean

    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param eventId the ID of the event
     * @return whether the screenshot was successfully taken or not
     */
    fun takeScreenshotMoment(eventId: String): Boolean
}
