package io.embrace.android.embracesdk.comms.delivery

import io.embrace.android.embracesdk.BackgroundActivityMessage
import io.embrace.android.embracesdk.EventMessage
import io.embrace.android.embracesdk.NdkService
import io.embrace.android.embracesdk.SessionMessage
import io.embrace.android.embracesdk.payload.NetworkEvent

internal enum class SessionMessageState { START, END, END_WITH_CRASH }

internal interface DeliveryService : DeliveryServiceNetwork {
    fun saveSession(sessionMessage: SessionMessage)
    fun sendSession(sessionMessage: SessionMessage, state: SessionMessageState)
    fun sendCachedSessions(isNdkEnabled: Boolean, ndkService: NdkService, currentSession: String?)
    fun saveCrash(crash: EventMessage)
    fun sendEventAsync(eventMessage: EventMessage)
    fun saveBackgroundActivity(backgroundActivityMessage: BackgroundActivityMessage)
    fun sendBackgroundActivity(backgroundActivityMessage: BackgroundActivityMessage)
    fun sendBackgroundActivities()
}

internal interface DeliveryServiceNetwork {
    fun sendLogScreenshot(screenshot: ByteArray, logId: String)
    fun sendMomentScreenshot(screenshot: ByteArray, eventId: String)
    fun sendLogs(eventMessage: EventMessage)
    fun sendNetworkCall(networkEvent: NetworkEvent)
    fun sendEvent(eventMessage: EventMessage)
    fun sendEventAndWait(eventMessage: EventMessage)
    fun sendCrash(crash: EventMessage)
}
