package io.embrace.android.embracesdk.config.behavior

import io.embrace.android.embracesdk.config.local.BaseUrlLocalConfig

/**
 * Provides the behavior that the Background Activity feature should follow.
 */
internal class SdkEndpointBehavior(
    thresholdCheck: BehaviorThresholdCheck,
    localSupplier: () -> BaseUrlLocalConfig?,
) : MergedConfigBehavior<BaseUrlLocalConfig, UnimplementedConfig>(
    thresholdCheck,
    localSupplier
) {

    companion object {
        const val CONFIG_DEFAULT = "https://config.emb-api.com"
        const val DATA_DEFAULT = "https://data.emb-api.com"
        const val DATA_DEV_DEFAULT = "https://data-dev.emb-api.com"
        const val IMAGES_DEFAULT = "https://images.emb-api.com"
    }

    /**
     * Data base URL.
     */
    fun getData(): String = local?.data ?: DATA_DEFAULT

    /**
     * Data dev base URL.
     */
    fun getDataDev(): String = local?.dataDev ?: DATA_DEV_DEFAULT

    /**
     * Config base URL.
     */
    fun getConfig(): String = local?.config ?: CONFIG_DEFAULT

    /**
     * Images base URL.
     */
    fun getImages(): String = local?.images ?: IMAGES_DEFAULT
}
