package io.embrace.android.embracesdk.injection

import io.embrace.android.embracesdk.EmbraceNetworkCaptureService
import io.embrace.android.embracesdk.EmbraceNetworkLoggingService
import io.embrace.android.embracesdk.EmbraceRemoteLogger
import io.embrace.android.embracesdk.EmbraceSessionProperties
import io.embrace.android.embracesdk.NetworkCaptureService
import io.embrace.android.embracesdk.NetworkLoggingService
import io.embrace.android.embracesdk.capture.screenshot.EmbraceScreenshotService
import io.embrace.android.embracesdk.capture.screenshot.ScreenshotService
import io.embrace.android.embracesdk.worker.WorkerName
import io.embrace.android.embracesdk.worker.WorkerThreadModule

/**
 * Holds dependencies that are required for a customer to send log messages to the backend.
 */
internal interface CustomerLogModule {
    val networkCaptureService: NetworkCaptureService
    val networkLoggingService: NetworkLoggingService
    val remoteLogger: EmbraceRemoteLogger
    val screenshotService: ScreenshotService
}

internal class CustomerLogModuleImpl(
    essentialServiceModule: EssentialServiceModule,
    coreModule: CoreModule,
    deliveryModule: DeliveryModule,
    sessionProperties: EmbraceSessionProperties,
    dataCaptureServiceModule: DataCaptureServiceModule,
    workerThreadModule: WorkerThreadModule
) : CustomerLogModule {

    override val networkCaptureService: NetworkCaptureService by singleton {
        EmbraceNetworkCaptureService(
            essentialServiceModule.metadataService,
            essentialServiceModule.preferencesService,
            remoteLogger,
            essentialServiceModule.configService,
            coreModule.jsonSerializer
        )
    }

    override val networkLoggingService: NetworkLoggingService by singleton {
        EmbraceNetworkLoggingService(
            essentialServiceModule.configService,
            coreModule.logger,
            networkCaptureService
        )
    }

    override val remoteLogger: EmbraceRemoteLogger by singleton {
        EmbraceRemoteLogger(
            essentialServiceModule.metadataService,
            screenshotService,
            deliveryModule.deliveryService,
            essentialServiceModule.userService,
            essentialServiceModule.configService,
            sessionProperties,
            coreModule.logger,
            coreModule.clock,
            essentialServiceModule.gatingService,
            dataCaptureServiceModule.networkConnectivityService,
            workerThreadModule.backgroundWorker(WorkerName.REMOTE_LOGGING)
        )
    }

    override val screenshotService: ScreenshotService by singleton {
        EmbraceScreenshotService(
            essentialServiceModule.activityService,
            essentialServiceModule.configService,
            deliveryModule.deliveryService,
            coreModule.logger,
            coreModule.clock
        )
    }
}
