package io.embrace.android.embracesdk.injection

import io.embrace.android.embracesdk.EmbraceEventService
import io.embrace.android.embracesdk.EmbraceSessionProperties
import io.embrace.android.embracesdk.EventService
import io.embrace.android.embracesdk.NativeModule
import io.embrace.android.embracesdk.capture.EmbracePerformanceInfoService
import io.embrace.android.embracesdk.capture.PerformanceInfoService
import io.embrace.android.embracesdk.internal.spans.EmbraceSpansService
import io.embrace.android.embracesdk.internal.spans.SpansService
import io.embrace.android.embracesdk.worker.WorkerThreadModule

/**
 * Holds dependencies that normally act as a 'container' for other data. For example,
 * a span, an Event, PerformanceInfo, etc.
 */
internal interface DataContainerModule {
    val performanceInfoService: PerformanceInfoService
    val eventService: EventService
    val spansService: SpansService
}

internal class DataContainerModuleImpl(
    essentialServiceModule: EssentialServiceModule,
    coreModule: CoreModule,
    dataCaptureServiceModule: DataCaptureServiceModule,
    anrModule: AnrModule,
    customerLogModule: CustomerLogModule,
    deliveryModule: DeliveryModule,
    nativeModule: NativeModule,
    sessionProperties: EmbraceSessionProperties,
    sharedWorkers: WorkerThreadModule,
    startTime: Long
) : DataContainerModule {

    override val spansService: SpansService by singleton {
        EmbraceSpansService(coreModule.clock)
    }

    override val performanceInfoService: PerformanceInfoService by singleton {
        EmbracePerformanceInfoService(
            anrModule.anrService,
            dataCaptureServiceModule.networkConnectivityService,
            customerLogModule.networkLoggingService,
            dataCaptureServiceModule.powerSaveModeService,
            dataCaptureServiceModule.memoryService,
            essentialServiceModule.metadataService,
            anrModule.googleAnrTimestampRepository,
            dataCaptureServiceModule.appExitInfoService,
            dataCaptureServiceModule.strictModeService,
            nativeModule.nativeThreadSamplerService
        )
    }

    override val eventService: EventService by singleton {
        EmbraceEventService(
            startTime,
            deliveryModule.deliveryService,
            essentialServiceModule.configService,
            essentialServiceModule.metadataService,
            performanceInfoService,
            essentialServiceModule.userService,
            customerLogModule.screenshotService,
            sessionProperties,
            coreModule.logger,
            sharedWorkers,
            coreModule.clock,
            spansService
        )
    }
}
