package io.embrace.android.embracesdk.injection

import io.embrace.android.embracesdk.DeliveryNetworkManager
import io.embrace.android.embracesdk.EmbraceDeliveryService
import io.embrace.android.embracesdk.comms.delivery.CacheService
import io.embrace.android.embracesdk.comms.delivery.DeliveryCacheManager
import io.embrace.android.embracesdk.comms.delivery.DeliveryService
import io.embrace.android.embracesdk.comms.delivery.EmbraceCacheService
import io.embrace.android.embracesdk.worker.WorkerName
import io.embrace.android.embracesdk.worker.WorkerThreadModule

internal interface DeliveryModule {
    val cacheService: CacheService
    val deliveryCacheManager: DeliveryCacheManager
    val deliveryNetworkManager: DeliveryNetworkManager
    val deliveryService: DeliveryService
}

internal class DeliveryModuleImpl(
    coreModule: CoreModule,
    essentialServiceModule: EssentialServiceModule,
    dataCaptureServiceModule: DataCaptureServiceModule,
    workerThreadModule: WorkerThreadModule
) : DeliveryModule {

    private val cachedSessionsWorker = workerThreadModule.backgroundWorker(WorkerName.CACHED_SESSIONS)
    private val sendSessionsWorker = workerThreadModule.backgroundWorker(WorkerName.SEND_SESSIONS)
    private val deliveryCacheWorker = workerThreadModule.backgroundWorker(WorkerName.DELIVERY_CACHE)
    private val apiRetryWorker = workerThreadModule.scheduledExecutor(WorkerName.API_RETRY)

    override val cacheService: CacheService by singleton {
        EmbraceCacheService(coreModule.context, coreModule.jsonSerializer, coreModule.logger)
    }

    override val deliveryCacheManager: DeliveryCacheManager by singleton {
        DeliveryCacheManager(
            cacheService,
            deliveryCacheWorker,
            coreModule.logger,
            coreModule.clock,
            coreModule.jsonSerializer
        )
    }

    override val deliveryNetworkManager: DeliveryNetworkManager by singleton {
        DeliveryNetworkManager(
            essentialServiceModule.metadataService,
            essentialServiceModule.urlBuilder,
            essentialServiceModule.apiClient,
            deliveryCacheManager,
            coreModule.logger,
            essentialServiceModule.configService,
            apiRetryWorker,
            dataCaptureServiceModule.networkConnectivityService,
            coreModule.jsonSerializer
        )
    }

    override val deliveryService: DeliveryService by singleton {
        EmbraceDeliveryService(
            deliveryCacheManager,
            deliveryNetworkManager,
            cachedSessionsWorker,
            sendSessionsWorker,
            coreModule.logger,
            essentialServiceModule.configService
        )
    }
}
