package io.embrace.android.embracesdk.injection

import io.embrace.android.embracesdk.EmbraceInternalErrorService
import io.embrace.android.embracesdk.InternalErrorLogger
import io.embrace.android.embracesdk.logging.AndroidLogger

/**
 * Contains dependencies that are used to gain internal observability into how the SDK
 * is performing.
 */
internal interface SdkObservabilityModule {
    val exceptionService: EmbraceInternalErrorService
    val internalErrorLogger: InternalErrorLogger
}

internal class SdkObservabilityModuleImpl(
    coreModule: CoreModule,
    essentialServiceModule: EssentialServiceModule
) : SdkObservabilityModule {

    private val logStrictMode by lazy {
        val configService = essentialServiceModule.configService
        configService.sessionBehavior.isSessionErrorLogStrictModeEnabled() ||
            configService.sdkModeBehavior.isIntegrationModeEnabled()
    }

    override val exceptionService: EmbraceInternalErrorService by singleton {
        EmbraceInternalErrorService(essentialServiceModule.activityService, coreModule.clock, logStrictMode)
    }

    override val internalErrorLogger: InternalErrorLogger by singleton {
        InternalErrorLogger(exceptionService, AndroidLogger(), logStrictMode)
    }
}
