package io.embrace.android.embracesdk.internal.api

import io.embrace.android.embracesdk.internal.spans.EmbraceAttributes
import io.embrace.android.embracesdk.internal.spans.EmbraceSpan
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanEvent
import io.embrace.android.embracesdk.internal.spans.ErrorCode

/**
 * Public interface for SDK users to create custom Spans
 */
internal interface EmbraceTracer {

    /**
     * Create an [EmbraceSpan] with the given name
     */
    fun createSpan(name: String): EmbraceSpan?

    /**
     * Execute the given block of code and record span around it. If the span cannot be created, the block of code will still run and
     * return correctly. If an exception or error is thrown inside the block, the span will end at the point of the throw and the
     * [Throwable] will not be caught
     */
    fun <T> recordSpan(name: String, code: () -> T): T

    /**
     * Record a span with the given start and end times, along with any attributes and events that occurred during it, in additional to
     * whether or not the span was ended successfully (a non-null [EmbraceAttributes.ErrorCode] denotes the span failed to complete
     * successfully.
     */
    fun recordCompletedSpan(
        name: String,
        startTimeNanos: Long,
        endTimeNanos: Long,
        attributes: Map<String, String> = emptyMap(),
        events: List<EmbraceSpanEvent> = emptyList(),
        errorCode: ErrorCode? = null
    ): Boolean
}
