package io.embrace.android.embracesdk.internal.spans

import io.opentelemetry.api.trace.Span
import io.opentelemetry.api.trace.SpanBuilder

internal class EmbraceSpanImpl(private val spanBuilder: SpanBuilder) : EmbraceSpan {
    @Volatile
    private var startedSpan: Span? = null

    override fun start(): Boolean {
        startedSpan = spanBuilder.startSpan()
        return startedSpan != null
    }

    override fun stop(errorCode: ErrorCode?): Boolean {
        return if (startedSpan?.isRecording == false) {
            false
        } else {
            startedSpan?.endSpan(errorCode)
            startedSpan?.isRecording == false
        }
    }

    override val traceId: String?
        get() = startedSpan?.spanContext?.traceId

    override val spanId: String?
        get() = startedSpan?.spanContext?.spanId

    override val isRecording: Boolean
        get() = startedSpan?.isRecording == true
}
