package io.embrace.android.embracesdk.internal.spans

import io.embrace.android.embracesdk.internal.api.EmbraceTracer
import io.opentelemetry.api.common.Attributes
import io.opentelemetry.sdk.trace.data.EventData

internal class EmbraceTracerImpl(private val spansService: SpansService) : EmbraceTracer {
    override fun createSpan(name: String): EmbraceSpan? =
        spansService.createSpan(
            name = name,
            type = EmbraceAttributes.Type.PERFORMANCE
        )

    override fun <T> recordSpan(name: String, code: () -> T): T =
        spansService.recordSpan(
            name = name,
            type = EmbraceAttributes.Type.PERFORMANCE,
            code = code
        )

    override fun recordCompletedSpan(
        name: String,
        startTimeNanos: Long,
        endTimeNanos: Long,
        attributes: Map<String, String>,
        events: List<EmbraceSpanEvent>,
        errorCode: ErrorCode?
    ): Boolean =
        spansService.recordCompletedSpan(
            name = name,
            startTimeNanos = startTimeNanos,
            endTimeNanos = endTimeNanos,
            type = EmbraceAttributes.Type.PERFORMANCE,
            attributes = attributes,
            events = convertToEventData(events),
            errorCode = errorCode
        )

    private fun convertToEventData(events: List<EmbraceSpanEvent>): List<EventData> {
        val eventDataList = mutableListOf<EventData>()
        events.forEach { event ->
            val attributesBuilder = Attributes.builder()
            event.attributes.forEach { attribute ->
                attributesBuilder.put(attribute.key, attribute.value)
            }
            eventDataList.add(
                EventData.create(
                    event.timestamp,
                    event.name,
                    attributesBuilder.build()
                )
            )
        }
        return eventDataList.toList()
    }
}
