package io.embrace.android.embracesdk.internal.spans

import io.embrace.android.embracesdk.InternalApi
import io.opentelemetry.sdk.common.CompletableResultCode
import io.opentelemetry.sdk.trace.data.EventData
import io.opentelemetry.sdk.trace.data.SpanData

/**
 * An implementation of [SpansService] that does nothing, to be used when the feature is not enabled
 */
@InternalApi
internal class FeatureDisabledSpansService : SpansService {
    override fun createSpan(name: String, type: EmbraceAttributes.Type): EmbraceSpan? = null

    override fun <T> recordSpan(name: String, type: EmbraceAttributes.Type, code: () -> T) = code()

    override fun recordCompletedSpan(
        name: String,
        startTimeNanos: Long,
        endTimeNanos: Long,
        type: EmbraceAttributes.Type,
        attributes: Map<String, String>,
        events: List<EventData>,
        errorCode: ErrorCode?
    ): Boolean = false

    override fun storeCompletedSpans(spans: List<SpanData>): CompletableResultCode = CompletableResultCode.ofFailure()

    override fun completedSpans(): List<EmbraceSpanData>? = null

    override fun flushSpans(appTerminationCause: EmbraceAttributes.AppTerminationCause?): List<EmbraceSpanData>? = null
}
