package io.embrace.android.embracesdk.internal.utils

import io.embrace.android.embracesdk.InternalApi

/**
 * Utilities to handle edge cases related to working with Throwables
 */

/**
 * Extension function that returns null for the stacktrace of a [Throwable] if an exception is thrown while trying to get it
 */
@InternalApi
internal fun Throwable.getSafeStackTrace(): Array<StackTraceElement>? {
    return try {
        this.stackTrace
    } catch (ex: Exception) {
        null
    }
}

/**
 * Return the canonical name of the cause of a [Throwable]. Handles null elements throughout,
 * including the throwable and its cause, in which case an empty string is returned
 */
@InternalApi
internal fun causeName(throwable: Throwable?): String {
    return throwable?.cause?.javaClass?.canonicalName ?: ""
}

/**
 * Return the message of the cause of a [Throwable]. Handles null elements throughout,
 * including the throwable and its cause, in which case an empty string is returned
 */
@InternalApi
internal fun causeMessage(throwable: Throwable?): String {
    return throwable?.cause?.message ?: ""
}
