package io.embrace.android.embracesdk.networking;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.io.IOException;
import java.net.MalformedURLException;

import io.embrace.android.embracesdk.InternalApi;

@InternalApi
public abstract class EmbraceUrl {

    private static UrlFactory embraceUrlFactory = null;

    static void setEmbraceUrlFactory(@Nullable UrlFactory urlConstructor) {
        embraceUrlFactory = urlConstructor;
    }

    @NonNull
    @InternalApi
    public static EmbraceUrl getUrl(@NonNull String url) throws MalformedURLException {
        if (embraceUrlFactory != null) {
            try {
                return embraceUrlFactory.getInstance(url);
            } catch (Exception expected) {
            }
        }
        return new EmbraceUrlImpl(url);
    }


    @NonNull
    public String toString() {
        return getFile();
    }

    @NonNull
    public abstract EmbraceConnection openConnection() throws IOException;

    @NonNull
    public abstract String getFile();

    interface UrlFactory {
        EmbraceUrl getInstance(@NonNull String url);
    }
}

