package io.embrace.android.embracesdk.payload

import com.google.gson.annotations.SerializedName

/**
 * Describes a particular Java exception. Where an exception has a cause, there will be an
 * [ExceptionInfo] for each nested cause.
 */
internal data class ExceptionInfo internal constructor(

    /**
     * The name of the class throwing the exception.
     */
    @SerializedName("n") val name: String,

    /**
     * The exception message.
     */
    @SerializedName("m") val message: String?,

    /**
     * String representation of each line of the stack trace.
     */
    @SerializedName("tt")
    val lines: List<String>
) {

    companion object {

        /**
         * Creates a [ExceptionInfo] from a [Throwable], using the classname as the name,
         * the exception message as the message, and each stacktrace element as each line.
         *
         * @param throwable the exception
         * @return the stacktrace instance
         */
        @JvmStatic
        fun ofThrowable(throwable: Throwable): ExceptionInfo {
            val name = throwable.javaClass.name
            val message = throwable.message ?: ""
            val lines = throwable.stackTrace.map(StackTraceElement::toString)
            return ExceptionInfo(name, message, lines)
        }
    }
}
