package io.embrace.android.embracesdk.payload

import com.google.gson.annotations.SerializedName

@Suppress("UnusedPrivateMember")
internal data class NetworkCallV2(
    /** The URL being requested.  */
    @SerializedName("url")
    val url: String? = null,

    /** The HTTP method the network request corresponds to.  */
    @SerializedName("x")
    private val httpMethod: String? = null,

    /** The HTTP response code.  */
    @SerializedName("rc")
    private val responseCode: Int? = null,

    /** The number of bytes sent during the network request.  */
    @SerializedName("bo")
    private val bytesSent: Long = 0,

    /** The number of bytes received during the network request.  */
    @SerializedName("bi")
    private val bytesReceived: Long = 0,

    /** The start time of the request.  */
    @SerializedName("st")
    private val startTime: Long = 0,

    /** The end time of the request.  */
    @SerializedName("et")
    private val endTime: Long = 0,

    /** The duration of the network request.  */
    @SerializedName("dur")
    private val duration: Long = 0,

    /** The trace ID that can be used to trace a particular request.  */
    @SerializedName("t")
    private val traceId: String? = null,

    /** If an exception was thrown, the name of the class which caused the exception.  */
    @SerializedName("ed")
    private val errorType: String? = null,

    /** If an exception was thrown, the exception message.  */
    @SerializedName("de")
    private val errorMessage: String? = null
)
