package io.embrace.android.embracesdk.utils

import android.os.Build
import android.text.TextUtils

internal class NativeUtils private constructor() {
    companion object {

        @JvmStatic
        fun is32BitDevice(): Boolean {
            return when {
                Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP -> !TextUtils.join(
                    ", ",
                    Build.SUPPORTED_ABIS
                ).contains("64")
                else -> true
            }
        }
    }
}
