package io.embrace.android.embracesdk.utils.exceptions.function;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;

/**
 * A checked version of {@code Consumer}.
 * <p>
 * This is intended to be used with {@link Unchecked}.
 *
 * @param <T> the type of the object parameter
 */
@FunctionalInterface
@InternalApi
public interface CheckedConsumer<T> {

    /**
     * Performs this operation on the given argument.
     *
     * @param t the input argument
     * @throws Throwable if an error occurs
     */
    public void accept(T t) throws Throwable;

}
