package io.embrace.android.embracesdk.utils.exceptions.function;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;

/**
 * A checked version of {@code Predicate}.
 * <p>
 * This is intended to be used with {@link Unchecked}.
 *
 * @param <T> the type of the object parameter
 */
@FunctionalInterface
@InternalApi
public interface CheckedPredicate<T> {

    /**
     * Evaluates this predicate on the given argument.
     *
     * @param t the input argument
     * @return true if the input argument matches the predicate
     * @throws Throwable if an error occurs
     */
    public boolean test(T t) throws Throwable;

}
