package io.embrace.android.embracesdk.worker

import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors
import java.util.concurrent.ScheduledExecutorService

/**
 * A set of shared executors and background workers to be used throughout the SDK
 */
// This lint error seems spurious as it only flags methods annotated with @JvmStatic even though the accessor is generated regardless
// for lazily initialized members
internal class WorkerThreadModuleImpl : WorkerThreadModule {

    private val threads: MutableMap<WorkerName, ScheduledExecutorService> = ConcurrentHashMap()

    private fun fetchExecutor(workerName: WorkerName): ScheduledExecutorService {
        return threads.getOrPut(workerName) {
            val threadName = workerName.threadName
            val threadFactory = WorkerUtils.createThreadFactory(threadName)
            val service = Executors.newSingleThreadScheduledExecutor(threadFactory)
            WorkerUtils.shutdownHook(service, threadName)
            service
        }
    }

    // TODO: update everywhere to use the workerThreadModule instead of directly calling here.

    override fun backgroundExecutor(workerName: WorkerName): ExecutorService =
        fetchExecutor(workerName)

    override fun scheduledExecutor(workerName: WorkerName): ScheduledExecutorService =
        fetchExecutor(workerName)

    override fun backgroundWorker(workerName: WorkerName): BackgroundWorker =
        BackgroundWorker(fetchExecutor(workerName))

    override fun close() {
        threads.values.forEach(ScheduledExecutorService::shutdown)
    }
}
