package io.embrace.android.embracesdk.worker

import android.os.Process
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger.Companion.logDebug
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors
import java.util.concurrent.ThreadFactory
import java.util.concurrent.TimeUnit

internal object WorkerUtils {

    fun createThreadFactory(name: String): ThreadFactory = ThreadFactory { runnable: Runnable ->
        Executors.defaultThreadFactory().newThread(runnable).apply {
            this.name = "Embrace $name"
        }
    }

    fun shutdownHook(service: ExecutorService, name: String) {
        Runtime.getRuntime().addShutdownHook(
            Thread(
                object : PriorityRunnable() {
                    override fun runWithPriority() {
                        try {
                            logDebug("Shutdown hook for executor called")
                            service.shutdown()
                            if (!service.awaitTermination(4, TimeUnit.SECONDS)) {
                                logDebug("Executor did not shut down in time, shutting down immediately")
                                service.shutdownNow()
                            }
                        } catch (ex: InterruptedException) {
                            logDebug("Interrupted whilst attempting to shut down.")
                            service.shutdownNow()
                            Thread.currentThread().interrupt()
                        }
                    }
                },
                "Embrace Shutdown Hook for Worker: $name"
            )
        )
    }

    private abstract class PriorityRunnable : Runnable {

        override fun run() {
            Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND)
        }

        abstract fun runWithPriority()
    }
}
