/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import com.google.gson.Gson;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.VerificationResult;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\u0010H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J\r\u0010\u0017\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/embrace/android/embracesdk/AutomaticVerificationChecker;", "", "()V", "file", "Ljava/io/File;", "fileName", "", "gson", "Lcom/google/gson/Gson;", "verificationResult", "Lio/embrace/android/embracesdk/VerificationResult;", "addException", "", "e", "", "createFile", "", "activity", "Landroid/app/Activity;", "deleteFile", "generateMarkerFile", "getExceptions", "", "isVerificationCorrect", "()Ljava/lang/Boolean;", "embrace-android-sdk_release"})
public final class AutomaticVerificationChecker {
    private final String fileName;
    private final VerificationResult verificationResult = new VerificationResult();
    private File file;
    private Gson gson = new Gson();

    public final boolean createFile(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        File file = activity.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"activity.cacheDir");
        String directory = file.getAbsolutePath();
        this.file = new File(directory + '/' + this.fileName);
        return this.generateMarkerFile();
    }

    private final boolean generateMarkerFile() {
        boolean result2 = false;
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        if (!file.exists()) {
            File file2 = this.file;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            result2 = file2.createNewFile();
        }
        return result2;
    }

    public final void deleteFile() {
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        if (file.exists()) {
            File file2 = this.file;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            if (!file2.isDirectory()) {
                File file3 = this.file;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"file");
                }
                file3.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Boolean isVerificationCorrect() {
        try {
            if (this.file != null) {
                File file = this.file;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"file");
                }
                String fileContent = FilesKt.readText$default((File)file, null, (int)1, null);
                CharSequence charSequence = fileContent;
                boolean bl = false;
                return charSequence.length() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(((VerificationResult)this.gson.fromJson(fileContent, VerificationResult.class)).getExceptions().isEmpty());
            }
        }
        catch (FileNotFoundException e) {
            void this_$iv;
            InternalEmbraceLogger internalEmbraceLogger = InternalStaticEmbraceLogger.logger;
            String msg$iv = "cannot open file";
            boolean logStacktrace$iv = false;
            boolean $i$f$logError = false;
            this_$iv.log(msg$iv, EmbraceLogger.Severity.ERROR, e, logStacktrace$iv);
        }
        return null;
    }

    public final void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.verificationResult.getExceptions().add(e);
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        FilesKt.writeText$default((File)file, (String)this.gson.toJson((Object)this.verificationResult).toString(), null, (int)2, null);
    }

    @NotNull
    public final List<Throwable> getExceptions() {
        String fileContent;
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return StringsKt.isBlank((CharSequence)(fileContent = FilesKt.readText$default((File)file, null, (int)1, null))) ? CollectionsKt.emptyList() : ((VerificationResult)this.gson.fromJson(fileContent, VerificationResult.class)).getExceptions();
    }

    public AutomaticVerificationChecker() {
        this.fileName = "emb_marker_file.txt";
    }

    public static final /* synthetic */ File access$getFile$p(AutomaticVerificationChecker $this) {
        File file = $this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return file;
    }

    public static final /* synthetic */ void access$setFile$p(AutomaticVerificationChecker $this, File file) {
        $this.file = file;
    }
}

